/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.DialogWindow;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.StorageHolder;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlEmbed;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrame;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlObject;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptFunctionJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnly;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnlyStatus;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ApplicationCache;
import com.gargoylesoftware.htmlunit.javascript.host.Console;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.External;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollectionFrames;
import com.gargoylesoftware.htmlunit.javascript.host.History;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Navigator;
import com.gargoylesoftware.htmlunit.javascript.host.Netscape;
import com.gargoylesoftware.htmlunit.javascript.host.Screen;
import com.gargoylesoftware.htmlunit.javascript.host.Storage;
import com.gargoylesoftware.htmlunit.javascript.host.Symbol;
import com.gargoylesoftware.htmlunit.javascript.host.WindowProxy;
import com.gargoylesoftware.htmlunit.javascript.host.crypto.Crypto;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.MediaQueryList;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleMedia;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.DataTransfer;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.performance.Performance;
import com.gargoylesoftware.htmlunit.javascript.host.speech.SpeechSynthesis;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.svg.SvgPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class Window
extends EventTarget
implements ScriptableWithFallbackGetter,
Function,
AutoCloseable {
    private static final Log LOG = LogFactory.getLog(Window.class);
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final short TEMPORARY = 0;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final short PERSISTENT = 1;
    private static final int MIN_TIMER_DELAY = 1;
    private Document document_;
    private DocumentProxy documentProxy_;
    private Navigator navigator_;
    private WebWindow webWindow_;
    private WindowProxy windowProxy_;
    private Screen screen_;
    private History history_;
    private Location location_;
    private ScriptableObject console_;
    private ApplicationCache applicationCache_;
    private Selection selection_;
    private Event currentEvent_;
    private String status_ = "";
    private HTMLCollection frames_;
    private Map<Class<? extends Scriptable>, Scriptable> prototypes_ = new HashMap<Class<? extends Scriptable>, Scriptable>();
    private Map<String, Scriptable> prototypesPerJSName_ = new HashMap<String, Scriptable>();
    private Object controllers_;
    private Object opener_;
    private Object top_ = NOT_FOUND;
    private Crypto crypto_;
    private transient WeakHashMap<Element, Map<String, CSS2Properties>> computedStyles_ = new WeakHashMap();
    private final Map<StorageHolder.Type, Storage> storages_ = new HashMap<StorageHolder.Type, Storage>();
    private static final Set<String> ATTRIBUTES_AFFECTING_PARENT = new HashSet<String>(Arrays.asList("style", "class", "height", "width"));

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        throw ScriptRuntime.typeError("Illegal constructor");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.computedStyles_ = new WeakHashMap();
    }

    @Override
    public Scriptable getPrototype(Class<? extends SimpleScriptable> jsClass) {
        return this.prototypes_.get(jsClass);
    }

    public Scriptable getPrototype(String className) {
        return this.prototypesPerJSName_.get(className);
    }

    public void setPrototypes(Map<Class<? extends Scriptable>, Scriptable> map, Map<String, Scriptable> prototypesPerJSName) {
        this.prototypes_ = map;
        this.prototypesPerJSName_ = prototypesPerJSName;
    }

    @JsxFunction
    public void alert(Object message) {
        String stringMessage = Context.toString(message);
        AlertHandler handler = this.getWebWindow().getWebClient().getAlertHandler();
        if (handler == null) {
            LOG.warn("window.alert(\"" + stringMessage + "\") no alert handler installed");
        } else {
            handler.handleAlert(this.document_.getPage(), stringMessage);
        }
    }

    @JsxFunction
    public String btoa(String stringToEncode) {
        return new String(Base64.encodeBase64(stringToEncode.getBytes()));
    }

    @JsxFunction
    public String atob(String encodedData) {
        return new String(Base64.decodeBase64(encodedData.getBytes()));
    }

    @JsxFunction
    public boolean confirm(String message) {
        ConfirmHandler handler = this.getWebWindow().getWebClient().getConfirmHandler();
        if (handler == null) {
            LOG.warn("window.confirm(\"" + message + "\") no confirm handler installed, simulating the OK button");
            return true;
        }
        return handler.handleConfirm(this.document_.getPage(), message);
    }

    @JsxFunction
    public String prompt(String message) {
        PromptHandler handler = this.getWebWindow().getWebClient().getPromptHandler();
        if (handler == null) {
            LOG.warn("window.prompt(\"" + message + "\") no prompt handler installed");
            return null;
        }
        return handler.handlePrompt(this.document_.getPage(), message);
    }

    @JsxGetter(propertyName="document")
    public DocumentProxy getDocument_js() {
        return this.documentProxy_;
    }

    public Document getDocument() {
        return this.document_;
    }

    @JsxGetter
    public ApplicationCache getApplicationCache() {
        return this.applicationCache_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public Object getEvent() {
        return this.currentEvent_;
    }

    public Event getCurrentEvent() {
        return this.currentEvent_;
    }

    public void setCurrentEvent(Event event) {
        this.currentEvent_ = event;
    }

    @JsxFunction
    public WindowProxy open(Object url, Object name, Object features, Object replace) {
        WebClient webClient;
        String urlString = null;
        if (url != Undefined.instance) {
            urlString = Context.toString(url);
        }
        String windowName = "";
        if (name != Undefined.instance) {
            windowName = Context.toString(name);
        }
        String featuresString = null;
        if (features != Undefined.instance) {
            featuresString = Context.toString(features);
        }
        if ((webClient = this.getWebWindow().getWebClient()).getOptions().isPopupBlockerEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring window.open() invocation because popups are blocked.");
            }
            return null;
        }
        boolean replaceCurrentEntryInBrowsingHistory = false;
        if (replace != Undefined.instance) {
            replaceCurrentEntryInBrowsingHistory = Context.toBoolean(replace);
        }
        if ((featuresString != null || replaceCurrentEntryInBrowsingHistory) && LOG.isDebugEnabled()) {
            LOG.debug("window.open: features and replaceCurrentEntryInBrowsingHistory not implemented: url=[" + urlString + "] windowName=[" + windowName + "] features=[" + featuresString + "] replaceCurrentEntry=[" + replaceCurrentEntryInBrowsingHistory + "]");
        }
        if (StringUtils.isEmpty(urlString) && !"".equals(windowName)) {
            try {
                WebWindow webWindow = webClient.getWebWindowByName(windowName);
                return Window.getProxy(webWindow);
            }
            catch (WebWindowNotFoundException webWindow) {
                // empty catch block
            }
        }
        URL newUrl = this.makeUrlForOpenWindow(urlString);
        WebWindow newWebWindow = webClient.openWindow(newUrl, windowName, this.webWindow_);
        return Window.getProxy(newWebWindow);
    }

    private URL makeUrlForOpenWindow(String urlString) {
        if (urlString.isEmpty()) {
            return WebClient.URL_ABOUT_BLANK;
        }
        try {
            Page page = this.getWebWindow().getEnclosedPage();
            if (page != null && page.isHtmlPage()) {
                return ((HtmlPage)page).getFullyQualifiedUrl(urlString);
            }
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.error("Unable to create URL for openWindow: relativeUrl=[" + urlString + "]", e);
            return null;
        }
    }

    @JsxFunction
    public int setTimeout(Object code, int timeout, Object language) {
        int id;
        if (timeout < 1) {
            timeout = 1;
        }
        if (code == null) {
            throw Context.reportRuntimeError("Function not provided.");
        }
        WebWindow webWindow = this.getWebWindow();
        Page page = (Page)((Object)this.getDomNodeOrNull());
        if (code instanceof String) {
            String s = (String)code;
            String description = "window.setTimeout(" + s + ", " + timeout + ")";
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, null, description, webWindow, s);
            id = webWindow.getJobManager().addJob(job, page);
        } else if (code instanceof Function) {
            Function f = (Function)code;
            String functionName = f instanceof FunctionObject ? ((FunctionObject)f).getFunctionName() : String.valueOf(f);
            String description = "window.setTimeout(" + functionName + ", " + timeout + ")";
            JavaScriptFunctionJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, null, description, webWindow, f);
            id = webWindow.getJobManager().addJob(job, page);
        } else {
            throw Context.reportRuntimeError("Unknown type for function.");
        }
        return id;
    }

    @JsxFunction
    public void clearTimeout(int timeoutId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("clearTimeout(" + timeoutId + ")");
        }
        this.getWebWindow().getJobManager().removeJob(timeoutId);
    }

    @JsxGetter
    public Navigator getNavigator() {
        return this.navigator_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public Navigator getClientInformation() {
        return this.navigator_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public DataTransfer getClipboardData() {
        DataTransfer dataTransfer = new DataTransfer();
        dataTransfer.setParentScope(this);
        dataTransfer.setPrototype(this.getPrototype(dataTransfer.getClass()));
        return dataTransfer;
    }

    @JsxGetter(propertyName="window")
    public Window getWindow_js() {
        return this;
    }

    @JsxGetter
    public Window getSelf() {
        return this;
    }

    @JsxGetter
    public Storage getLocalStorage() {
        return this.getStorage(StorageHolder.Type.LOCAL_STORAGE);
    }

    @JsxGetter
    public Storage getSessionStorage() {
        return this.getStorage(StorageHolder.Type.SESSION_STORAGE);
    }

    public Storage getStorage(StorageHolder.Type storageType) {
        Storage storage = this.storages_.get((Object)storageType);
        if (storage == null) {
            WebWindow webWindow = this.getWebWindow();
            Map<String, String> store = webWindow.getWebClient().getStorageHolder().getStore(storageType, webWindow.getEnclosedPage());
            storage = new Storage(this, store);
            this.storages_.put(storageType, storage);
        }
        return storage;
    }

    @JsxGetter
    public Location getLocation() {
        return this.location_;
    }

    @JsxSetter
    public void setLocation(String newLocation) throws IOException {
        this.location_.setHref(newLocation);
    }

    @JsxGetter
    public ScriptableObject getConsole() {
        return this.console_;
    }

    @JsxSetter
    public void setConsole(ScriptableObject console) {
        this.console_ = console;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void dump(String message) {
        if (this.console_ instanceof Console) {
            Console.log(null, this.console_, new Object[]{message}, null);
        }
    }

    @JsxFunction
    public int requestAnimationFrame(Object callback) {
        return 1;
    }

    @JsxFunction
    public void cancelAnimationFrame(Object requestId) {
    }

    @JsxGetter
    public Screen getScreen() {
        return this.screen_;
    }

    @JsxGetter
    public History getHistory() {
        return this.history_;
    }

    @JsxGetter
    public External getExternal() {
        External external = new External();
        external.setParentScope(this);
        external.setPrototype(this.getPrototype(external.getClass()));
        return external;
    }

    public void initialize(WebWindow webWindow) {
        WebWindow opener;
        this.webWindow_ = webWindow;
        this.webWindow_.setScriptableObject(this);
        this.windowProxy_ = new WindowProxy(this.webWindow_);
        Page enclosedPage = webWindow.getEnclosedPage();
        this.document_ = enclosedPage instanceof XmlPage || enclosedPage instanceof SvgPage ? new XMLDocument() : new HTMLDocument();
        this.document_.setParentScope(this);
        this.document_.setPrototype(this.getPrototype(this.document_.getClass()));
        this.document_.setWindow(this);
        if (enclosedPage instanceof SgmlPage) {
            SgmlPage page = (SgmlPage)enclosedPage;
            this.document_.setDomNode(page);
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            page.addDomChangeListener(listener);
            if (page.isHtmlPage()) {
                ((HtmlPage)page).addHtmlAttributeChangeListener(listener);
                ((HtmlPage)page).addAutoCloseable(this);
            }
        }
        this.documentProxy_ = new DocumentProxy(this.webWindow_);
        this.navigator_ = new Navigator();
        this.navigator_.setParentScope(this);
        this.navigator_.setPrototype(this.getPrototype(this.navigator_.getClass()));
        this.screen_ = new Screen();
        this.screen_.setParentScope(this);
        this.screen_.setPrototype(this.getPrototype(this.screen_.getClass()));
        this.history_ = new History();
        this.history_.setParentScope(this);
        this.history_.setPrototype(this.getPrototype(this.history_.getClass()));
        this.location_ = new Location();
        this.location_.setParentScope(this);
        this.location_.setPrototype(this.getPrototype(this.location_.getClass()));
        this.location_.initialize(this);
        this.console_ = new Console();
        ((Console)this.console_).setWebWindow(this.webWindow_);
        this.console_.setParentScope(this);
        ((Console)this.console_).setPrototype(this.getPrototype(((SimpleScriptable)this.console_).getClass()));
        this.applicationCache_ = new ApplicationCache();
        this.applicationCache_.setParentScope(this);
        this.applicationCache_.setPrototype(this.getPrototype(this.applicationCache_.getClass()));
        Context ctx = Context.getCurrentContext();
        this.controllers_ = ctx.newObject(this);
        if (this.webWindow_ instanceof TopLevelWindow && (opener = ((TopLevelWindow)this.webWindow_).getOpener()) != null) {
            this.opener_ = opener.getScriptableObject();
        }
    }

    public void initialize(Page enclosedPage) {
        if (enclosedPage != null && enclosedPage.isHtmlPage()) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            this.setDomNode(htmlPage);
            this.clearEventListenersContainer();
            WebAssert.notNull("document_", this.document_);
            this.document_.setDomNode(htmlPage);
        }
    }

    public void initialize() {
    }

    @JsxGetter
    public Object getTop() {
        if (this.top_ != NOT_FOUND) {
            return this.top_;
        }
        WebWindow top = this.getWebWindow().getTopWindow();
        return top.getScriptableObject();
    }

    @JsxSetter
    public void setTop(Object o) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_TOP_WRITABLE)) {
            this.top_ = o;
        }
    }

    @JsxGetter
    public ScriptableObject getParent() {
        WebWindow parent = this.getWebWindow().getParentWindow();
        return parent.getScriptableObject();
    }

    @JsxGetter
    public Object getOpener() {
        Object opener = this.opener_;
        if (opener instanceof Window) {
            opener = ((Window)opener).windowProxy_;
        }
        return opener;
    }

    @JsxSetter
    public void setOpener(Object newValue) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_CHANGE_OPENER_ONLY_WINDOW_OBJECT) && newValue != null && newValue != Undefined.instance && !(newValue instanceof Window)) {
            throw Context.reportRuntimeError("Can't set opener to something other than a window!");
        }
        this.opener_ = newValue;
    }

    @JsxGetter
    public Object getFrameElement() {
        WebWindow window = this.getWebWindow();
        if (window instanceof FrameWindow) {
            return ((FrameWindow)window).getFrameElement().getScriptableObject();
        }
        return null;
    }

    @JsxGetter(propertyName="frames")
    public Window getFrames_js() {
        return this;
    }

    @JsxGetter
    public int getLength() {
        return this.getFrames().getLength();
    }

    private HTMLCollection getFrames() {
        if (this.frames_ == null) {
            HtmlPage page = (HtmlPage)this.getWebWindow().getEnclosedPage();
            this.frames_ = new HTMLCollectionFrames(page);
        }
        return this.frames_;
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    @JsxFunction
    public void focus() {
        WebWindow window = this.getWebWindow();
        window.getWebClient().setCurrentWindow(window);
    }

    @JsxFunction
    public void blur() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.blur() not implemented");
        }
    }

    @JsxFunction(functionName="close")
    public void close_js() {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof TopLevelWindow) {
            ((TopLevelWindow)webWindow).close();
        } else {
            webWindow.getWebClient().deregisterWebWindow(webWindow);
        }
    }

    @JsxGetter
    @CanSetReadOnly(value=CanSetReadOnlyStatus.IGNORE)
    public boolean getClosed() {
        WebWindow webWindow = this.getWebWindow();
        return !webWindow.getWebClient().containsWebWindow(webWindow);
    }

    @JsxFunction
    public void moveTo(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.moveTo() not implemented");
        }
    }

    @JsxFunction
    public void moveBy(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.moveBy() not implemented");
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void navigate(String url) throws IOException {
        this.getLocation().assign(url);
    }

    @JsxFunction
    public void resizeBy(int width, int height) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.resizeBy() not implemented");
        }
    }

    @JsxFunction
    public void resizeTo(int width, int height) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.resizeTo() not implemented");
        }
    }

    @JsxFunction
    public void scroll(int x, int y) {
        this.scrollTo(x, y);
    }

    @JsxFunction
    public void scrollBy(int x, int y) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollLeft(body.getScrollLeft() + x);
            body.setScrollTop(body.getScrollTop() + y);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void scrollByLines(int lines) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollTop(body.getScrollTop() + 19 * lines);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void scrollByPages(int pages) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollTop(body.getScrollTop() + this.getInnerHeight() * pages);
        }
    }

    @JsxFunction
    public void scrollTo(int x, int y) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollLeft(x);
            body.setScrollTop(y);
        }
    }

    @JsxGetter
    public Object getOnload() {
        Object onload = this.getHandlerForJavaScript("load");
        if (onload == null) {
            HtmlPage page = (HtmlPage)this.getWebWindow().getEnclosedPage();
            HtmlElement body = page.getBody();
            if (body != null) {
                HTMLBodyElement b = (HTMLBodyElement)body.getScriptableObject();
                return b.getEventHandler("onload");
            }
            return null;
        }
        return onload;
    }

    @JsxSetter
    public void setOnload(Object onload) {
        this.getEventListenersContainer().setEventHandlerProp("load", onload);
    }

    @JsxGetter
    public Object getOnclick() {
        return this.getHandlerForJavaScript("click");
    }

    @JsxSetter
    public void setOnclick(Object onclick) {
        this.setHandlerForJavaScript("click", onclick);
    }

    @JsxGetter
    public Object getOndblclick() {
        return this.getHandlerForJavaScript("dblclick");
    }

    @JsxSetter
    public void setOndblclick(Object ondblclick) {
        this.setHandlerForJavaScript("dblclick", ondblclick);
    }

    @JsxGetter
    public Object getOnhashchange() {
        return this.getHandlerForJavaScript("hashchange");
    }

    @JsxSetter
    public void setOnhashchange(Object onhashchange) {
        this.setHandlerForJavaScript("hashchange", onhashchange);
    }

    @JsxGetter
    public String getName() {
        return this.getWebWindow().getName();
    }

    @JsxSetter
    public void setName(String name) {
        this.getWebWindow().setName(name);
    }

    @JsxGetter
    public Object getOnbeforeunload() {
        return this.getHandlerForJavaScript("beforeunload");
    }

    @JsxSetter
    public void setOnbeforeunload(Object onbeforeunload) {
        this.setHandlerForJavaScript("beforeunload", onbeforeunload);
    }

    @JsxGetter
    public Object getOnerror() {
        return this.getHandlerForJavaScript("error");
    }

    @JsxSetter
    public void setOnerror(Object onerror) {
        this.setHandlerForJavaScript("error", onerror);
    }

    @JsxGetter
    public Object getOnmessage() {
        return this.getHandlerForJavaScript("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setHandlerForJavaScript("message", onmessage);
    }

    public void triggerOnError(ScriptException e) {
        Object o = this.getOnerror();
        if (o instanceof Function) {
            Function f = (Function)o;
            String msg = e.getMessage();
            String url = e.getPage().getUrl().toExternalForm();
            int line = e.getFailingLineNumber();
            int column = e.getFailingColumnNumber();
            Object[] args = new Object[]{msg, url, line, column, e};
            f.call(Context.getCurrentContext(), this, this, args);
        }
    }

    private Object getHandlerForJavaScript(String eventName) {
        return this.getEventListenersContainer().getEventHandlerProp(eventName);
    }

    private void setHandlerForJavaScript(String eventName, Object handler) {
        if (handler == null || handler instanceof Function) {
            this.getEventListenersContainer().setEventHandlerProp(eventName, handler);
        }
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        throw Context.reportRuntimeError("Window is not a function.");
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw Context.reportRuntimeError("Window is not a function.");
    }

    @Override
    public Object getWithFallback(String name) {
        Object result = NOT_FOUND;
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode != null) {
            HtmlPage page = (HtmlPage)domNode.getPage();
            result = Window.getFrameWindowByName(page, name);
            if (result == NOT_FOUND && (result = this.getElementsByName(page, name)) == NOT_FOUND) {
                try {
                    Object htmlElement = page.getHtmlElementById(name);
                    if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_FRAME_BY_ID_RETURNS_WINDOW) && htmlElement instanceof HtmlFrame) {
                        HtmlFrame frame = (HtmlFrame)htmlElement;
                        result = this.getScriptableFor(frame.getEnclosedWindow());
                    } else {
                        result = this.getScriptableFor(htmlElement);
                    }
                }
                catch (ElementNotFoundException e) {
                    result = NOT_FOUND;
                }
            }
            if (result instanceof Window) {
                WebWindow webWindow = ((Window)result).getWebWindow();
                result = Window.getProxy(webWindow);
            }
        }
        return result;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.getWebWindow() == null) {
            return Undefined.instance;
        }
        HTMLCollection frames = this.getFrames();
        if (index < 0 || index >= frames.getLength()) {
            return Undefined.instance;
        }
        return frames.item(index);
    }

    private static Object getFrameWindowByName(HtmlPage page, String name) {
        try {
            return page.getFrameByName(name).getScriptableObject();
        }
        catch (ElementNotFoundException e) {
            return NOT_FOUND;
        }
    }

    private Object getElementsByName(final HtmlPage page, String name) {
        List<DomElement> elements = page.getElementsByName(name);
        boolean includeFormFields = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_FORMFIELDS_ACCESSIBLE_BY_NAME);
        final Filter filter = new Filter(includeFormFields);
        Iterator<DomElement> it = elements.iterator();
        while (it.hasNext()) {
            if (filter.matches(it.next())) continue;
            it.remove();
        }
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            return this.getScriptableFor(elements.get(0));
        }
        final String expElementName = "null".equals(name) ? "" : name;
        return new HTMLCollection(page, true){

            @Override
            protected List<Object> computeElements() {
                List<DomElement> expElements = page.getElementsByName(expElementName);
                ArrayList<Object> result = new ArrayList<Object>(expElements.size());
                for (DomElement domElement : expElements) {
                    if (!filter.matches(domElement)) continue;
                    result.add(domElement);
                }
                return result;
            }

            @Override
            protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                if ("name".equals(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            }
        };
    }

    public static WindowProxy getProxy(WebWindow w) {
        return ((Window)w.getScriptableObject()).windowProxy_;
    }

    @JsxGetter
    public String getStatus() {
        return this.status_;
    }

    @JsxSetter
    public void setStatus(String message) {
        this.status_ = message;
        StatusHandler statusHandler = this.webWindow_.getWebClient().getStatusHandler();
        if (statusHandler != null) {
            statusHandler.statusMessageChanged(this.webWindow_.getEnclosedPage(), message);
        }
    }

    @JsxFunction
    public int setInterval(Object code, int timeout, Object language) {
        int id;
        if (timeout < 1) {
            timeout = 1;
        }
        WebWindow w = this.getWebWindow();
        Page page = (Page)((Object)this.getDomNodeOrNull());
        String description = "window.setInterval(" + timeout + ")";
        if (code == null) {
            throw Context.reportRuntimeError("Function not provided.");
        }
        if (code instanceof String) {
            String s = (String)code;
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, (Integer)timeout, description, w, s);
            id = this.getWebWindow().getJobManager().addJob(job, page);
        } else if (code instanceof Function) {
            Function f = (Function)code;
            JavaScriptFunctionJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, (Integer)timeout, description, w, f);
            id = this.getWebWindow().getJobManager().addJob(job, page);
        } else {
            throw Context.reportRuntimeError("Unknown type for function.");
        }
        return id;
    }

    @JsxFunction
    public void clearInterval(int intervalID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("clearInterval(" + intervalID + ")");
        }
        this.getWebWindow().getJobManager().removeJob(intervalID);
    }

    @JsxGetter
    public int getInnerWidth() {
        return this.getWebWindow().getInnerWidth();
    }

    @JsxGetter
    public int getOuterWidth() {
        return this.getWebWindow().getOuterWidth();
    }

    @JsxGetter
    public int getInnerHeight() {
        return this.getWebWindow().getInnerHeight();
    }

    @JsxGetter
    public int getOuterHeight() {
        return this.getWebWindow().getOuterHeight();
    }

    @JsxFunction
    public void print() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.print() not implemented");
        }
    }

    @JsxFunction
    public void captureEvents(String type) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void CollectGarbage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsxFunction
    public CSS2Properties getComputedStyle(Object element, String pseudoElement) {
        if (!(element instanceof Element)) {
            throw ScriptRuntime.typeError("parameter 1 is not of type 'Element'");
        }
        Element e = (Element)element;
        WeakHashMap<Element, Map<String, CSS2Properties>> weakHashMap = this.computedStyles_;
        synchronized (weakHashMap) {
            CSS2Properties style;
            Map<String, CSS2Properties> elementMap = this.computedStyles_.get(e);
            if (elementMap != null && (style = elementMap.get(pseudoElement)) != null) {
                return style;
            }
        }
        CSSStyleDeclaration original = e.getStyle();
        CSS2Properties style = new CSS2Properties(original);
        StyleSheetList sheets = ((HTMLDocument)e.getOwnerDocument()).getStyleSheets();
        boolean trace = LOG.isTraceEnabled();
        for (int i = 0; i < sheets.getLength(); ++i) {
            CSSStyleSheet sheet = (CSSStyleSheet)sheets.item(i);
            if (!sheet.isActive() || !sheet.isEnabled()) continue;
            if (trace) {
                LOG.trace("modifyIfNecessary: " + sheet + ", " + style + ", " + e);
            }
            sheet.modifyIfNecessary(style, e, pseudoElement);
        }
        WeakHashMap<Element, Map<String, CSS2Properties>> weakHashMap2 = this.computedStyles_;
        synchronized (weakHashMap2) {
            Map<String, CSS2Properties> elementMap = this.computedStyles_.get(element);
            if (elementMap == null) {
                elementMap = new WeakHashMap<String, CSS2Properties>();
                this.computedStyles_.put(e, elementMap);
            }
            elementMap.put(pseudoElement, style);
        }
        return style;
    }

    @JsxFunction
    public Selection getSelection() {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof FrameWindow) {
            FrameWindow frameWindow = (FrameWindow)webWindow;
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_SELECTION_NULL_IF_INVISIBLE) && !frameWindow.getFrameElement().isDisplayed()) {
                return null;
            }
        }
        return this.getSelectionImpl();
    }

    public Selection getSelectionImpl() {
        if (this.selection_ == null) {
            this.selection_ = new Selection();
            this.selection_.setParentScope(this);
            this.selection_.setPrototype(this.getPrototype(this.selection_.getClass()));
        }
        return this.selection_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public Object showModalDialog(String url, Object arguments, String features) {
        WebWindow webWindow = this.getWebWindow();
        WebClient client = webWindow.getWebClient();
        try {
            URL completeUrl = ((HtmlPage)this.getDomNodeOrDie()).getFullyQualifiedUrl(url);
            DialogWindow dialog = client.openDialogWindow(completeUrl, webWindow, arguments);
            ScriptableObject jsDialog = dialog.getScriptableObject();
            return jsDialog.get("returnValue", (Scriptable)jsDialog);
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object showModelessDialog(String url, Object arguments, String features) {
        WebWindow webWindow = this.getWebWindow();
        WebClient client = webWindow.getWebClient();
        try {
            URL completeUrl = ((HtmlPage)this.getDomNodeOrDie()).getFullyQualifiedUrl(url);
            DialogWindow dialog = client.openDialogWindow(completeUrl, webWindow, arguments);
            Window jsDialog = (Window)dialog.getScriptableObject();
            return jsDialog;
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public Object getControllers() {
        return this.controllers_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setControllers(Object value) {
        this.controllers_ = value;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getMozInnerScreenX() {
        return 11;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getMozInnerScreenY() {
        return 91;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getMozPaintCount() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearComputedStyles() {
        WeakHashMap<Element, Map<String, CSS2Properties>> weakHashMap = this.computedStyles_;
        synchronized (weakHashMap) {
            this.computedStyles_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearComputedStyles(Element element) {
        WeakHashMap<Element, Map<String, CSS2Properties>> weakHashMap = this.computedStyles_;
        synchronized (weakHashMap) {
            this.computedStyles_.remove(element);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public String ScriptEngine() {
        return "JScript";
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public int ScriptEngineBuildVersion() {
        return 12345;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public int ScriptEngineMajorVersion() {
        return this.getBrowserVersion().getBrowserVersionNumeric();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public int ScriptEngineMinorVersion() {
        return 0;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public void stop() {
    }

    @JsxGetter
    public int getPageXOffset() {
        return 0;
    }

    @JsxGetter
    public int getPageYOffset() {
        return 0;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public int getScrollX() {
        return 0;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public int getScrollY() {
        return 0;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public Netscape getNetscape() {
        return new Netscape(this);
    }

    @Override
    public boolean isConst(String name) {
        if ("undefined".equals(name) || "Infinity".equals(name) || "NaN".equals(name)) {
            return false;
        }
        return super.isConst(name);
    }

    @Override
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        ScriptResult result = this.fireEvent(event);
        return !event.isAborted(result);
    }

    @JsxGetter
    public Object getOnchange() {
        return this.getHandlerForJavaScript("change");
    }

    @JsxSetter
    public void setOnchange(Object onchange) {
        this.setHandlerForJavaScript("change", onchange);
    }

    @JsxGetter
    public Object getOnsubmit() {
        return this.getHandlerForJavaScript("submit");
    }

    @JsxSetter
    public void setOnsubmit(Object onsubmit) {
        this.setHandlerForJavaScript("submit", onsubmit);
    }

    @JsxFunction
    public void postMessage(String message, String targetOrigin, Object transfer) {
        URL currentURL = this.getWebWindow().getEnclosedPage().getUrl();
        if (!"*".equals(targetOrigin) && !"/".equals(targetOrigin)) {
            URL targetURL = null;
            try {
                targetURL = new URL(targetOrigin);
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx(new Exception("SyntaxError: Failed to execute 'postMessage' on 'Window': Invalid target origin '" + targetOrigin + "' was specified (reason: " + e.getMessage() + "."));
            }
            if (Window.getPort(targetURL) != Window.getPort(currentURL)) {
                return;
            }
            if (!targetURL.getHost().equals(currentURL.getHost())) {
                return;
            }
            if (!targetURL.getProtocol().equals(currentURL.getProtocol())) {
                return;
            }
        }
        final MessageEvent event = new MessageEvent();
        String origin = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
        event.initMessageEvent("message", false, false, message, origin, "", this, transfer);
        event.setParentScope(this);
        event.setPrototype(this.getPrototype(event.getClass()));
        final JavaScriptEngine jsEngine = this.getWebWindow().getWebClient().getJavaScriptEngine();
        PostponedAction action = new PostponedAction(this.getDomNodeOrDie().getPage()){

            @Override
            public void execute() throws Exception {
                ContextAction contextAction = new ContextAction(){

                    @Override
                    public Object run(Context cx) {
                        return Window.this.dispatchEvent(event);
                    }
                };
                HtmlUnitContextFactory cf = jsEngine.getContextFactory();
                cf.call(contextAction);
            }
        };
        jsEngine.addPostponedAction(action);
    }

    public static int getPort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = "http".equals(url.getProtocol()) ? 80 : 443;
        }
        return port;
    }

    @JsxGetter
    public Performance getPerformance() {
        Performance performance = new Performance();
        performance.setParentScope(this);
        performance.setPrototype(this.getPrototype(performance.getClass()));
        return performance;
    }

    @JsxGetter
    public int getDevicePixelRatio() {
        return 1;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public StyleMedia getStyleMedia() {
        StyleMedia styleMedia = new StyleMedia();
        styleMedia.setParentScope(this);
        styleMedia.setPrototype(this.getPrototype(styleMedia.getClass()));
        return styleMedia;
    }

    @JsxFunction
    public MediaQueryList matchMedia(String mediaQueryString) {
        MediaQueryList mediaQueryList = new MediaQueryList(mediaQueryString);
        mediaQueryList.setParentScope(this);
        mediaQueryList.setPrototype(this.getPrototype(mediaQueryList.getClass()));
        return mediaQueryList;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public boolean find(String search, boolean caseSensitive, boolean backwards, boolean wrapAround, boolean wholeWord, boolean searchInFrames, boolean showDialog) {
        return false;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public SpeechSynthesis getSpeechSynthesis() {
        SpeechSynthesis speechSynthesis = new SpeechSynthesis();
        speechSynthesis.setParentScope(this);
        speechSynthesis.setPrototype(this.getPrototype(speechSynthesis.getClass()));
        return speechSynthesis;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public Object getOffscreenBuffering() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_FRAMES_ACCESSIBLE_BY_ID)) {
            return "auto";
        }
        return true;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public Crypto getCrypto() {
        if (this.crypto_ == null) {
            this.crypto_ = new Crypto(this);
        }
        return this.crypto_;
    }

    @Override
    public void close() {
        Symbol.remove(this);
    }

    @Override
    public void setParentScope(Scriptable parent) {
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private DomHtmlAttributeChangeListenerImpl() {
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode(), null);
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode(), null);
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement(), event.getName());
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement(), event.getName());
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement(), event.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nodeChanged(DomNode changed, String attribName) {
            String rel;
            if (changed instanceof HtmlStyle) {
                Window.this.clearComputedStyles();
                return;
            }
            if (changed instanceof HtmlLink && "stylesheet".equals(rel = ((HtmlLink)changed).getRelAttribute().toLowerCase(Locale.ROOT))) {
                Window.this.clearComputedStyles();
                return;
            }
            WeakHashMap weakHashMap = Window.this.computedStyles_;
            synchronized (weakHashMap) {
                boolean clearParents = ATTRIBUTES_AFFECTING_PARENT.contains(attribName);
                Iterator i = Window.this.computedStyles_.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    DomElement node = ((Element)entry.getKey()).getDomNodeOrDie();
                    if (changed != node && changed.getParentNode() != node.getParentNode() && !changed.isAncestorOf(node) && (!clearParents || !node.isAncestorOf(changed))) continue;
                    i.remove();
                }
            }
        }
    }

    private static final class Filter {
        private final boolean includeFormFields_;

        private Filter(boolean includeFormFields) {
            this.includeFormFields_ = includeFormFields;
        }

        private boolean matches(Object object) {
            if (object instanceof HtmlEmbed || object instanceof HtmlForm || object instanceof HtmlImage || object instanceof HtmlObject) {
                return true;
            }
            return this.includeFormFields_ && (object instanceof HtmlAnchor || object instanceof HtmlButton || object instanceof HtmlInput || object instanceof HtmlMap || object instanceof HtmlSelect || object instanceof HtmlTextArea);
        }
    }
}

