/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSubCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass
public class HTMLCollection
extends AbstractList {
    private int currentIndex_ = 0;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLCollection() {
    }

    private HTMLCollection(ScriptableObject parentScope) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public HTMLCollection(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive);
    }

    HTMLCollection(DomNode domNode, List<?> initialElements) {
        super(domNode, initialElements);
    }

    public static HTMLCollection emptyCollection(Window window) {
        final List list = Collections.emptyList();
        return new HTMLCollection((ScriptableObject)window){

            @Override
            public List<Object> getElements() {
                return list;
            }
        };
    }

    @Override
    protected AbstractList create(DomNode parentScope, List<?> initialElements) {
        return new HTMLCollection(parentScope, initialElements);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (this.supportsParanteses()) {
            return super.call(cx, scope, thisObj, args);
        }
        throw Context.reportRuntimeError("TypeError - HTMLCollection does nont support function like access");
    }

    protected boolean supportsParanteses() {
        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_SUPPORTS_PARANTHESES);
    }

    @Override
    protected Object getWithPreemptionByName(String name, List<Object> elements) {
        ArrayList<Object> matchingElements = new ArrayList<Object>();
        boolean searchName = this.isGetWithPreemptionSearchName();
        for (Object next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !searchName && !(next instanceof HtmlInput) && !(next instanceof HtmlForm) || !name.equals(nodeName = ((DomElement)next).getAttribute("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            Object object;
            Double doubleValue;
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_SUPPORTS_DOUBLE_INDEX_ALSO) && ScriptRuntime.NaN != (doubleValue = Double.valueOf(Context.toNumber(name))) && !doubleValue.isNaN() && (object = this.get(doubleValue.intValue(), (Scriptable)this)) != NOT_FOUND) {
                return object;
            }
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection(domNode, matchingElements);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    protected boolean isGetWithPreemptionSearchName() {
        return true;
    }

    @Override
    public Object item(Object index) {
        Object object;
        if (index instanceof String && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_SUPPORTS_ID_SEARCH_ALSO)) {
            String name = (String)index;
            Object result = this.namedItem(name);
            return result;
        }
        int idx = 0;
        Double doubleValue = Context.toNumber(index);
        if (ScriptRuntime.NaN != doubleValue && !doubleValue.isNaN()) {
            idx = doubleValue.intValue();
        }
        if ((object = this.get(idx, (Scriptable)this)) == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @JsxFunction
    public Object namedItem(String name) {
        DomElement elem;
        List<Object> elements = this.getElements();
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NAMED_ITEM_ID_FIRST)) {
            for (Object next : elements) {
                String id;
                if (!(next instanceof DomElement) || !name.equals(id = (elem = (DomElement)next).getId())) continue;
                return this.getScriptableForElement(elem);
            }
        }
        for (Object next : elements) {
            if (!(next instanceof DomElement)) continue;
            elem = (DomElement)next;
            String nodeName = elem.getAttribute("name");
            if (name.equals(nodeName)) {
                return this.getScriptableForElement(elem);
            }
            String id = elem.getId();
            if (!name.equals(id)) continue;
            return this.getScriptableForElement(elem);
        }
        return null;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object nextNode() {
        List<Object> elements = this.getElements();
        Object nextNode = this.currentIndex_ >= 0 && this.currentIndex_ < elements.size() ? elements.get(this.currentIndex_) : null;
        ++this.currentIndex_;
        return nextNode;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void reset() {
        this.currentIndex_ = 0;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object tags(final String tagName) {
        HTMLSubCollection collection = new HTMLSubCollection(this){

            @Override
            protected boolean isMatching(DomNode node) {
                return tagName.equalsIgnoreCase(node.getLocalName());
            }
        };
        return collection;
    }
}

