/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.PointerEvent;
import com.gargoylesoftware.htmlunit.javascript.host.file.FileList;
import com.gargoylesoftware.htmlunit.javascript.host.html.FormField;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.LabelsHelper;
import java.io.IOException;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.xml.sax.helpers.AttributesImpl;

@JsxClass(domClass=HtmlInput.class)
public class HTMLInputElement
extends FormField {
    private AbstractList labels_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLInputElement() {
    }

    @JsxGetter
    public String getType() {
        return this.getDomNodeOrDie().getTypeAttribute().toLowerCase(Locale.ROOT);
    }

    @JsxSetter
    public void setType(String newType) {
        HtmlInput input = this.getDomNodeOrDie();
        String currentType = input.getAttribute("type");
        if (!currentType.equalsIgnoreCase(newType)) {
            AttributesImpl attributes;
            int index;
            if (newType != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INPUT_SET_TYPE_LOWERCASE)) {
                newType = newType.toLowerCase(Locale.ROOT);
            }
            if ((index = (attributes = this.readAttributes(input)).getIndex("type")) > -1) {
                attributes.setValue(index, newType);
            } else {
                attributes.addAttribute(null, "type", "type", null, newType);
            }
            if (DomElement.ATTRIBUTE_NOT_DEFINED != currentType || !"text".equalsIgnoreCase(newType)) {
                HtmlInput newInput = (HtmlInput)InputElementFactory.instance.createElement(input.getPage(), "input", attributes);
                if (input.wasCreatedByJavascript()) {
                    newInput.markAsCreatedByJavascript();
                }
                if (input.getParentNode() == null) {
                    input = newInput;
                } else {
                    input.getParentNode().replaceChild(newInput, input);
                }
                input.setScriptableObject(null);
                this.setDomNode(newInput, true);
            } else {
                super.setAttribute("type", newType);
            }
        }
    }

    @Override
    public void setValue(Object newValue) {
        if (null == newValue) {
            this.getDomNodeOrDie().setAttribute("value", "");
            return;
        }
        String val = Context.toString(newValue);
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (StringUtils.isNotEmpty(val) && "file".equalsIgnoreCase(this.getType())) {
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_SELECT_FILE_THROWS)) {
                throw Context.reportRuntimeError("InvalidStateError: Failed to set the 'value' property on 'HTMLInputElement'.");
            }
            return;
        }
        if (StringUtils.isBlank(val)) {
            if ("email".equalsIgnoreCase(this.getType()) && browserVersion.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_EMAIL_TRIMMED)) {
                val = "";
            } else if ("url".equalsIgnoreCase(this.getType()) && browserVersion.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_URL_TRIMMED)) {
                val = "";
            }
        }
        this.getDomNodeOrDie().setAttribute("value", val);
    }

    @JsxSetter
    public void setChecked(boolean checked) {
        this.getDomNodeOrDie().setChecked(checked);
    }

    @Override
    public HtmlInput getDomNodeOrDie() {
        return (HtmlInput)super.getDomNodeOrDie();
    }

    @JsxGetter
    public boolean getChecked() {
        return this.getDomNodeOrDie().isChecked();
    }

    @JsxFunction
    public void select() {
        HtmlInput input = this.getDomNodeOrDie();
        if (input instanceof HtmlTextInput) {
            ((HtmlTextInput)input).select();
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("type".equals(name)) {
            this.setType(value);
            return;
        }
        super.setAttribute(name, value);
    }

    @JsxGetter
    public String getDefaultValue() {
        return this.getDomNodeOrDie().getDefaultValue();
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        this.getDomNodeOrDie().setDefaultValue(defaultValue);
    }

    @JsxGetter
    public boolean getDefaultChecked() {
        return this.getDomNodeOrDie().isDefaultChecked();
    }

    @JsxSetter
    public void setDefaultChecked(boolean defaultChecked) {
        this.getDomNodeOrDie().setDefaultChecked(defaultChecked);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter
    public int getSelectionStart() {
        return ((SelectableTextInput)((Object)this.getDomNodeOrDie())).getSelectionStart();
    }

    @JsxSetter
    public void setSelectionStart(int start) {
        ((SelectableTextInput)((Object)this.getDomNodeOrDie())).setSelectionStart(start);
    }

    @JsxGetter
    public int getSelectionEnd() {
        return ((SelectableTextInput)((Object)this.getDomNodeOrDie())).getSelectionEnd();
    }

    @JsxSetter
    public void setSelectionEnd(int end) {
        ((SelectableTextInput)((Object)this.getDomNodeOrDie())).setSelectionEnd(end);
    }

    @JsxGetter
    public int getMaxLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("maxLength");
        return NumberUtils.toInt(attrValue, -1);
    }

    @JsxSetter
    public void setMaxLength(int length) {
        this.getDomNodeOrDie().setMaxLength(length);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public int getMinLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("minLength");
        return NumberUtils.toInt(attrValue, -1);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public void setMinLength(int length) {
        this.getDomNodeOrDie().setMinLength(length);
    }

    @JsxGetter
    public String getMin() {
        return this.getDomNodeOrDie().getAttribute("min");
    }

    @JsxSetter
    public void setMin(String min) {
        this.getDomNodeOrDie().setAttribute("min", min);
    }

    @JsxGetter
    public String getMax() {
        return this.getDomNodeOrDie().getAttribute("max");
    }

    @JsxSetter
    public void setMax(String max) {
        this.getDomNodeOrDie().setAttribute("max", max);
    }

    @JsxGetter
    public boolean getReadOnly() {
        return this.getDomNodeOrDie().isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        this.getDomNodeOrDie().setReadOnly(readOnly);
    }

    @JsxFunction
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxGetter
    public String getAlt() {
        return this.getDomNodeOrDie().getAttribute("alt");
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBorder() {
        return this.getDomNodeOrDie().getAttribute("border");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        boolean ignoreIfNoError = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_FOR_INPUT_IGNORES_VALUES);
        this.setAlign(align, ignoreIfNoError);
    }

    @JsxGetter
    public String getSrc() {
        return this.getDomNodeOrDie().getSrcAttribute();
    }

    @Override
    public void click() throws IOException {
        HtmlInput domNode = this.getDomNodeOrDie();
        boolean originalState = domNode.isChecked();
        MouseEvent event = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(domNode, "click", false, false, false, 0) : new MouseEvent(domNode, "click", false, false, false, 0);
        domNode.click(event);
        boolean newState = domNode.isChecked();
        if (originalState != newState && (domNode instanceof HtmlRadioButtonInput || domNode instanceof HtmlCheckBoxInput)) {
            domNode.fireEvent("change");
        }
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }

    @JsxGetter
    public boolean isRequired() {
        return this.getDomNodeOrDie().isRequired();
    }

    @JsxSetter
    public void setRequired(boolean required) {
        this.getDomNodeOrDie().setRequired(required);
    }

    @JsxGetter
    public String getSize() {
        return this.getDomNodeOrDie().getSize();
    }

    @JsxSetter
    public void setSize(String size) {
        this.getDomNodeOrDie().setSize(size);
    }

    @JsxGetter
    public String getAccept() {
        return this.getDomNodeOrDie().getAccept();
    }

    @JsxSetter
    public void setAccept(String accept) {
        this.getDomNodeOrDie().setAccept(accept);
    }

    @JsxGetter
    public String getAutocomplete() {
        return this.getDomNodeOrDie().getAutocomplete();
    }

    @JsxSetter
    public void setAutocomplete(String autocomplete) {
        this.getDomNodeOrDie().setAutocomplete(autocomplete);
    }

    @JsxGetter
    public Object getFiles() {
        if (this.getDomNodeOrDie() instanceof HtmlFileInput) {
            FileList list = new FileList(HtmlFileInput.splitFiles(this.getValue()));
            list.setParentScope(this.getParentScope());
            list.setPrototype(this.getPrototype(list.getClass()));
            return list;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_FILES_UNDEFINED)) {
            return Undefined.instance;
        }
        return null;
    }

    @JsxGetter
    public String getPlaceholder() {
        return this.getDomNodeOrDie().getPlaceholder();
    }

    @JsxSetter
    public void setPlaceholder(String placeholder) {
        this.getDomNodeOrDie().setPlaceholder(placeholder);
    }

    @Override
    @JsxGetter
    public int getWidth() {
        String value = this.getDomNodeOrDie().getAttribute("width");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter
    public void setWidth(int width) {
        this.getDomNodeOrDie().setAttribute("width", Integer.toString(width));
    }

    @Override
    @JsxGetter
    public int getHeight() {
        String value = this.getDomNodeOrDie().getAttribute("height");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter
    public void setHeight(int height) {
        this.getDomNodeOrDie().setAttribute("height", Integer.toString(height));
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public AbstractList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsHelper(this.getDomNodeOrDie());
        }
        return this.labels_;
    }
}

