/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.html.FormField;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionsCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.LabelsHelper;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(domClass=HtmlSelect.class)
public class HTMLSelectElement
extends FormField {
    private HTMLOptionsCollection optionsArray_;
    private AbstractList labels_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLSelectElement() {
    }

    public void initialize() {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        htmlSelect.setScriptableObject(this);
        if (this.optionsArray_ == null) {
            this.optionsArray_ = new HTMLOptionsCollection(this);
            this.optionsArray_.initialize(htmlSelect);
        }
    }

    @JsxFunction
    public void remove(int index) {
        if (index < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_REMOVE_IGNORE_IF_INDEX_OUTSIDE)) {
            return;
        }
        HTMLOptionsCollection options = this.getOptions();
        if (index >= options.getLength() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_REMOVE_IGNORE_IF_INDEX_OUTSIDE)) {
            return;
        }
        this.getOptions().remove(index);
    }

    @JsxFunction
    public void add(HTMLOptionElement newOptionObject, Object beforeOptionObject) {
        this.getOptions().add(newOptionObject, beforeOptionObject);
    }

    @Override
    public Object appendChild(Object childObject) {
        Object object = super.appendChild(childObject);
        this.getHtmlSelect().ensureSelectedIndex();
        return object;
    }

    @Override
    public Object insertBeforeImpl(Object[] args) {
        Object object = super.insertBeforeImpl(args);
        this.getHtmlSelect().ensureSelectedIndex();
        return object;
    }

    @JsxFunction
    public Object item(int index) {
        Object option = this.getOptions().item(index);
        if (option == Undefined.instance) {
            return null;
        }
        return option;
    }

    @JsxGetter
    public String getType() {
        String type = this.getHtmlSelect().isMultipleSelectEnabled() ? "select-multiple" : "select-one";
        return type;
    }

    @JsxGetter
    public HTMLOptionsCollection getOptions() {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        return this.optionsArray_;
    }

    @JsxGetter
    public int getSelectedIndex() {
        return this.getHtmlSelect().getSelectedIndex();
    }

    @JsxSetter
    public void setSelectedIndex(int index) {
        this.getHtmlSelect().setSelectedIndex(index);
    }

    @Override
    public String getValue() {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        List<HtmlOption> selectedOptions = htmlSelect.getSelectedOptions();
        if (selectedOptions.isEmpty()) {
            return "";
        }
        return ((HTMLOptionElement)selectedOptions.get(0).getScriptableObject()).getValue();
    }

    @JsxGetter
    public int getLength() {
        return this.getOptions().getLength();
    }

    @JsxSetter
    public void setLength(int newLength) {
        this.getOptions().setLength(newLength);
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        return this.getOptions().get(index, start);
    }

    @Override
    public void put(int index, Scriptable start, Object newValue) {
        this.getOptions().put(index, start, newValue);
    }

    private HtmlSelect getHtmlSelect() {
        return (HtmlSelect)this.getDomNodeOrDie();
    }

    @Override
    public void setValue(Object newValue) {
        String val = Context.toString(newValue);
        this.getHtmlSelect().setSelectedAttribute(val, true, false);
    }

    @JsxGetter
    public int getSize() {
        int size = 0;
        String sizeAttribute = this.getDomNodeOrDie().getAttribute("size");
        if (sizeAttribute != DomElement.ATTRIBUTE_NOT_DEFINED && sizeAttribute != DomElement.ATTRIBUTE_VALUE_EMPTY) {
            try {
                size = Integer.parseInt(sizeAttribute);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return size;
    }

    @JsxSetter
    public void setSize(String size) {
        this.getDomNodeOrDie().setAttribute("size", size);
    }

    @JsxGetter
    public boolean getMultiple() {
        return this.getDomNodeOrDie().hasAttribute("multiple");
    }

    @JsxSetter
    public void setMultiple(boolean multiple) {
        if (multiple) {
            this.getDomNodeOrDie().setAttribute("multiple", "multiple");
        } else {
            this.getDomNodeOrDie().removeAttribute("multiple");
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public AbstractList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsHelper(this.getDomNodeOrDie());
        }
        return this.labels_;
    }
}

