/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.server.DriverProvider;

public class FirefoxDriverProvider
implements DriverProvider {
    private static final Logger LOG = Logger.getLogger(FirefoxDriverProvider.class.getName());

    @Override
    public Capabilities getProvidedCapabilities() {
        return DesiredCapabilities.firefox();
    }

    @Override
    public boolean canCreateDriverInstances() {
        return true;
    }

    @Override
    public boolean canCreateDriverInstanceFor(Capabilities capabilities) {
        return "firefox".equals(capabilities.getBrowserName());
    }

    @Override
    public WebDriver newInstance(Capabilities capabilities) {
        LOG.info("Creating a new session for " + capabilities);
        return this.callConstructor("org.openqa.selenium.firefox.FirefoxDriver", capabilities);
    }

    private Class<? extends WebDriver> getDriverClass(String driverClassName) {
        try {
            return Class.forName(driverClassName).asSubclass(WebDriver.class);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.INFO, "Driver class not found: " + driverClassName);
            return null;
        }
        catch (NoClassDefFoundError e) {
            LOG.log(Level.INFO, "Driver class not found: " + driverClassName);
            return null;
        }
        catch (UnsupportedClassVersionError e) {
            LOG.log(Level.INFO, "Driver class is built for higher Java version: " + driverClassName);
            return null;
        }
    }

    private WebDriver callConstructor(String driverClassName, Capabilities capabilities) {
        Class<? extends WebDriver> from = this.getDriverClass(driverClassName);
        try {
            Constructor<? extends WebDriver> constructor = from.getConstructor(Capabilities.class);
            return constructor.newInstance(capabilities);
        }
        catch (NoSuchMethodException e) {
            try {
                return from.newInstance();
            }
            catch (InstantiationException e1) {
                throw new WebDriverException(e);
            }
            catch (IllegalAccessException e1) {
                throw new WebDriverException(e);
            }
        }
        catch (InvocationTargetException e) {
            throw new WebDriverException(e);
        }
        catch (InstantiationException e) {
            throw new WebDriverException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebDriverException(e);
        }
    }

    public String toString() {
        return "Firefox/Marionette driver";
    }
}

